#' Connect to bulletin database
#'
#' Connect to bulletin database. This is a wrapper function that automatically connects to the correct database.
#'
#' @param Agency Name of agency (PkCan or AvCan)
#' @param DBFormat Name of bulletin database format. Needs to be either 'AvalX' (default) 'Bulletin' or 'HzdWebsite'.
#' @param User Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)
#' @param ReadOnly Boolean flag for whether the database connection should be read only (default is TRUE).
#' @return Database connection of the class MySQLConnection
#'
#' @examples
#' DBCon <- connectToBulletinDB("AvCan", "HzdWebsite")
#' Query <- "SELECT * FROM tbl_regions"
#' Result <- dbSendQuery(DBCon, Query)
#' Tbl_BulletinRegions <- dbFetch(Result, n=-1)
#' dbDisconnect(DBCon)
#' rm(DBCon, Query, Result)
#'
#' @export

connectToBulletinDB <- function(Agency, DBFormat="AvalX", User="", ReadOnly=T) {

  ## Preparation
  DBInfo <- getBulletinDBInfo(Agency, DBFormat)

  ## SARP MSSQL
  if(DBInfo$DBServer=="SARP-MSSQL") {

    DBCon <- connectToBulletinDB_SARP_MSSQL(DBInfo$DBName, User, ReadOnly)

  ## SARP MySQL
  } else if (DBInfo$DBServer=="SARP-MySQL") {
    
    DBCon <- connectToBulletinDB_SARP_MySQL(DBInfo$DBName, User, ReadOnly)
    
    ## Avisual MySQL
  } else if (DBInfo$DBServer=="Avisual-MySQL") {

    DBCon <- connectToBulletinDB_Avisual_MySQL(DBInfo$DBName, User, ReadOnly)

  } else {

    stop("Incorrect DBServer name!")

  }

  return(DBCon)

}
