#' Connect to Avisualanche MySQL Server Bulletin database
#'
#' Connect to specific Bulletin database on Avisualanche MySQL Server.
#'
#' @param DBName Name of database
#' @param User Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)
#' @param ReadOnly Boolean flag for whether the database connection should be read only (default is TRUE).
#' @return Database connection of the class MySQLConnection
#'
#' @export

connectToBulletinDB_Avisual_MySQL <- function(DBName, User="", ReadOnly=T) {

  ## Preparation
  User <- toupper(User)

  ## Username and password
  if(ReadOnly) {
    LoginName = "phaegeli_SFURead"
    LoginPW = "GPS$2015"
  } else {
    LoginName = "phaegeli_SFU"
    LoginPW = "GPS$2015"
  }

  DBCon <- RMySQL::dbConnect(dbDriver("MySQL"), host="avisualanche.ca", user=LoginName, password = LoginPW, dbname = DBName)

  return(DBCon)

}
