#' Connect to SARP MSSQL Server Bulletin database
#'
#' Connect to specific Bulletin database on SARP MSSQL Server.\cr
#' You need to install the necessary JDBC drivers of MS SQL Server on your local machine first. You can download these drivers from http://www.microsoft.com/en-us/download/details.aspx?displaylang=en&id=11774\cr
#' Instructions:\cr
#' 1) Windows\cr
#' - Download sqljdbc_<version>_<language>.exe to a temporary directory.\cr
#' - Run sqljdbc_<version>_<language>.exe and extract to a temporary folder on your desk top.\cr
#' - Create a new folder at 'C:/Program Files/JDBC/'.\cr
#' - Copy the content of the temperary folder on your desk top to 'C:/Program Files/JDBC/'.\cr
#' 2) Mac\cr
#' - Download sqljdbc_<version>_<language>.tar.gz to a temporary directory.\cr
#' - Unpack the zipped tar file.\cr
#' - Move the entire content of the uppacked tar file to '/etc' folder.
#'
#' @param DBName Name of database
#' @param User Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)
#' @param ReadOnly Boolean flag for whether the database connection should be read only (default is TRUE).
#' @return Database connection of the class JDBCConnection
#'
#' @export

connectToBulletinDB_SARP_MSSQL <- function(DBName, User="", ReadOnly=T) {
  
  SARP_MSSQLServer <- "142.58.21.196"

  ## Preparation
  User <- toupper(User)

  ## Username and password
  if(ReadOnly) {
    LoginName = "pascal"
    LoginPW = "success2288"
    ## Currently no account for read only
  } else {
    LoginName = "pascal"
    LoginPW = "success2288"
  }

  ## Connection from Mac platform
  if (.Platform$OS.type=="unix") {

    ## OPTION 1: RJDBC
    ## Requires local installation of JDBC drivers

    require(RJDBC)

    if(User=="PASCAL") {
      LocalFolderJDBC <- "/Users/pascal/Documents/sqljdbc_3.0/enu/sqljdbc4.jar"
    } else {
      LocalFolderJDBC <- "/etc/sqljdbc_3.0/enu/sqljdbc4.jar"
    }

    drv <- JDBC("com.microsoft.sqlserver.jdbc.SQLServerDriver", LocalFolderJDBC)
    DBCon <- RJDBC::dbConnect(drv, paste0("jdbc:sqlserver://", SARP_MSSQLServer, "; databaseName=", DBName, ";"), LoginName, LoginPW)

  ## Connection from Windows platform
  } else {

    ## OPTION 1: RJDBC
    ## Requires local installation of JDBC drivers

    require(RJDBC)

    if(User=="PASCAL") {
      LocalFolderJDBC <- "C:/Program Files/JDBC/sqljdbc_4.1/enu/sqljdbc4.jar"
    } else {
      LocalFolderJDBC <- "C:/Program Files/JDBC/sqljdbc_4.1/enu/sqljdbc4.jar"
    }

    drv <- JDBC("com.microsoft.sqlserver.jdbc.SQLServerDriver", LocalFolderJDBC)
    DBCon <- RJDBC::dbConnect(drv, paste0("jdbc:sqlserver://", SARP_MSSQLServer, "; databaseName=", DBName, ";"), LoginName, LoginPW)

    ## OPTION 2: RODBC
    ## Requires local ODBC setup

    # require(RODBC)
    # DBCon <- odbcConnect(DBName, uid=LoginName, pwd=LoginPW)

  }

  return(DBCon)
}
