#' Connect to SARP MySQL Server Bulletin database
#'
#' Connect to specific Bulletin database on SARP MySQL Server.
#'
#' @param DBName Name of database
#' @param User Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)
#' @param ReadOnly Boolean flag for whether the database connection should be read only (default is TRUE).
#' @return Database connection of the class MySQLConnection
#'
#' @export

connectToBulletinDB_SARP_MySQL <- function(DBName, User="", ReadOnly=T) {

  ## Preparation
  User <- toupper(User)

  ## Username and password
  if(ReadOnly) {
    LoginName = "pascal"
    LoginPW = "success2288"
  } else {
    LoginName = "pascal"
    LoginPW = "success2288"
  }

  DBCon <- RMySQL::dbConnect(dbDriver("MySQL"), host="142.58.21.196", user=LoginName, password = LoginPW, dbname = DBName)

  return(DBCon)

}
