#' Get name, server and type of bulletin database
#'
#' Get name, server and type of bulletin database for specific Agency abd database type
#' @param Agency Name of agency
#' @param DBFormat Name of bulletin database format. Needs to be either 'AvalX' (default) 'Bulletin' or 'HzdWebsite'.
#' @return DBName, DBServer and DBType in list form
#' @export

getBulletinDBInfo <- function(Agency, DBFormat="AvalX") {

  Agency <- toupper(Agency)
  DBFormat <- toupper(DBFormat)

  if (DBFormat=="AVALX") {

    if (Agency=="PKCAN") {
      DBName   <- "PkCan-AvalX"
      DBServer <- "SARP-MSSQL"
      DBType   <- "MSSQL"
    } else if (Agency=="AVCAN") {
      DBName   <- "AvCan-AvalX"
      DBServer <- "SARP-MSSQL"
      DBType   <- "MSSQL"
    } else {
      stop("Invalid value for Agency parameter for 'AvalX' database type!")
    }

  } else if (DBFormat=="BULLETIN") {

    if (Agency=="AVCAN") {
      DBName   <- "AvCan-Bulletin"
      DBServer <- "SARP-MSSQL"
      DBType   <- "MSSQL"
    } else {
      stop("Invalid value for Agency parameter for 'Bulletin' database type!")
    }

  } else if (DBFormat=="HZDWEBSITE") {

    if (Agency=="AVCAN") {
      DBName   <- "db_hzdwebsite_avcan"
      DBServer <- "SARP-MySQL"
      DBType   <- "MySQL"
    } else {
      stop("Invalid value for Agency parameter for 'HzdWebsite' database type!")
    }

  } else {

    stop("Incorrect value for DBFormat. Can only be 'AvalX' (default), 'Bulletin' or 'HzdWebsite'!")

  }

  Output <- list(DBName=DBName, DBServer=DBServer, DBType=DBType)
  return(Output)

}
