% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectToBulletinDB.R
\name{connectToBulletinDB}
\alias{connectToBulletinDB}
\title{Connect to bulletin database}
\usage{
connectToBulletinDB(Agency, DBFormat = "AvalX", User = "",
  ReadOnly = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{DBFormat}{Name of bulletin database format. Needs to be either 'AvalX' (default) 'Bulletin' or 'HzdWebsite'.}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{ReadOnly}{Boolean flag for whether the database connection should be read only (default is TRUE).}
}
\value{
Database connection of the class MySQLConnection
}
\description{
Connect to bulletin database. This is a wrapper function that automatically connects to the correct database.
}
\examples{
DBCon <- connectToBulletinDB("AvCan", "HzdWebsite")
Query <- "SELECT * FROM tbl_regions"
Result <- dbSendQuery(DBCon, Query)
Tbl_BulletinRegions <- dbFetch(Result, n=-1)
dbDisconnect(DBCon)
rm(DBCon, Query, Result)

}
