#' Add equivalent bulletin region names to list.
#'
#' Add equivalent bulletin region names to list.
#' @param BulletinRegionNameList List of bulletin regions
#' @return Expanded list of bulletin regions
#' @export
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' Region <- "South Coast - Inland"
#' (Test <- addEquivalentBulletinRegionNames(Region))
#'

addEquivalentBulletinRegionNames <- function(BulletinRegionNameList) {

  warning("Do not use this function anymore!", immediate. = T)

  ## Loop of bulletin region
  for (RegionIndex in 1:length(BulletinRegionNameList)) {

    ## Looop over list of bulletion region equivalency
    for (ListIndex in 1:length(BulletinRegionNamesEquivalency)) {

      if (BulletinRegionNameList[RegionIndex] %in% BulletinRegionNamesEquivalency[[ListIndex]]) {
        BulletinRegionNameList <- c(BulletinRegionNameList, BulletinRegionNamesEquivalency[[ListIndex]])
      }

    }

  }

  ## Remove duplicates
  BulletinRegionNameList <- unique(BulletinRegionNameList)

  ## Return
  return(BulletinRegionNameList)

}
