#' Combine bulletin objects.
#'
#' Combine bulletin objects.
#' @param BulletinObj1 First bulletin object
#' @param BulletinObj2 Second bulletin object
#' @return Object of type Bulletins
#'
#' @examples
#'
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' AvCan <- getBulletins("AvCan", Seasons=2017)
#' PkCan <- getBulletins("PkCan", Seasons=2017)
#'
#' Combined <- combineBulletinObjects(AvCan, PkCan)
#'
#' @export

combineBulletinObjects <- function(BulletinObj1, BulletinObj2) {

  ## Check bulletin objects
  if(!("Bulletins" %in% class(BulletinObj1))) {stop("BulletinObj1 not a bulletins object!")}
  if(!("Bulletins" %in% class(BulletinObj2))) {stop("BulletinObj2 not a bulletins object!")}

  ## Combine bulletin objects
  Combined <- list(Bulletins = rbind(BulletinObj1$Bulletins, BulletinObj2$Bulletins),
                   AvProblems = list(Alp = rbind(BulletinObj1$AvProblems$Alp, BulletinObj2$AvProblems$Alp),
                                     Tl  = rbind(BulletinObj1$AvProblems$Tl, BulletinObj2$AvProblems$Tl),
                                     Btl = rbind(BulletinObj1$AvProblems$Btl, BulletinObj2$AvProblems$Btl)),
                   DngRating = list(Alp = rbind(BulletinObj1$DngRating$Alp, BulletinObj2$DngRating$Alp),
                                    Tl = rbind(BulletinObj1$DngRating$Tl, BulletinObj2$DngRating$Tl),
                                    Btl = rbind(BulletinObj1$DngRating$Btl, BulletinObj2$DngRating$Btl)))

  ## Add class label
  class(Combined) <- append(class(Combined), "Bulletins")

  ## Return result
  return(Combined)

}
