#' Converts Bulletin avalanche problems in SarpBulletinTools package into spatial objects dataframe.
#'
#' Converts Bulletin avalanche problems in SarpBulletinTools package into spatial objects dataframe.
#' @param AvProblems Avalanche problems dataframe.
#' @param IDCol Name of datafram column with unique ID of avalanche problems.
#' @param Shape For specifying the shape of the blob. Values can be 'ellipse' (default) or 'square'.
#' @param NumPoints Number of point per quater section of ellipse. Default value is 50.
#' @return Avalanche problems as spatial dataframe object.

#' @export

convertAvProbToSPDF <- function(AvProblems, IDCol="PROBLEM_ID", Shape='ellipse', NumPoints=50) {

  if(!is.null(AvProblems)) {
    
    ## Rename relevant columns
    ## ***********************
    colnames(AvProblems)[which(colnames(AvProblems)=="SIZE_MIN")] <- "size_min"
    colnames(AvProblems)[which(colnames(AvProblems)=="SIZE_TYP")] <- "size_typ"
    colnames(AvProblems)[which(colnames(AvProblems)=="SIZE_MAX")] <- "size_max"
    colnames(AvProblems)[which(colnames(AvProblems)=="LIKELIHOOD_MIN")] <- "like_min"
    colnames(AvProblems)[which(colnames(AvProblems)=="LIKELIHOOD_TYP")] <- "like_typ"
    colnames(AvProblems)[which(colnames(AvProblems)=="LIKELIHOOD_MAX")] <- "like_max"
  
    ## Conversation using general function
    ## ***********************************
    ShapeSPDF <- convertAvProbToSPDFGeneral(AvProblems, IDCol=IDCol, Shape=Shape, NumPoints=NumPoints)

  } else {
    
    ShapeSPDF <- NA
    
  }
  ## Output
  ## ******
  return (ShapeSPDF)

}
