#' Returns a count of avalanche problem prevalance from a getBulletins() object
#'
#' Returns a count of avalanche problem prevalance from a getBulletins() object
#' @param Bulletin a getBulletins() object
#' @param Elevation defaults to Alpine. Options: 'ALP', 'TL', or 'BTL'
#'
#' @examples
#' require(SarpBulletinToolsPrivate)
#' require(SarpBulletinTools)
#'
#' Operation <- "AvCan"
#' Season <- 2015
#' Region <- "Sea-to-Sky"
#'
#' ## Entire Season - alpine elevation band
#' Bulletin <- getBulletins(Agency=Operation, Seasons=Season, Regions=Region)
#' 
#' countAvProb(Bulletin, Elevation = 'ALP')
#'
#' @export
countAvProb <- function(Bulletin, Elevation = 'ALP')
{
  ## elevation
  if(Elevation == 'ALP'){
    elv <- 1
  } else if(Elevation == 'TL'){
      elv <- 2
  } else if(Elevation == 'BTL'){
      elv <- 3
    } else
      stop(paste0("Elevation: ", AvCharLabel, " not supported! Check spelling! Either 'ALP','TL', or 'BTL'"))
  
  bulAvPrb <- Bulletin[[2]][[elv]][,c('BULLETIN_ID','CHARACTER')]
  bulAvPrb$CHARACTER <- as.character(bulAvPrb$CHARACTER)
  
  #Create dataframe for output
  df_AvProb <- data.frame(AvProb=c('Storm Slabs','Wind Slabs','Persistent Slabs', 'Deep Persistent Slabs','Any Persistent', 'Wet Slabs','Loose Wet','Loose Dry','Cornices' ),
                          NumBul=length(unique(bulAvPrb[,'BULLETIN_ID'])),
                          Count=0,
                          Perc=NA)
  # loop for each assessment
  for(temp_Ass in 1:length(unique(bulAvPrb[,'BULLETIN_ID'])))
  {
    #each bulletin
    temp_bul <- unique(bulAvPrb[,'BULLETIN_ID'])[temp_Ass]
    temp_AvPrb <- toupper(bulAvPrb[bulAvPrb[,'BULLETIN_ID'] == temp_bul,'CHARACTER'])
    # remove multiple avalanche problems of the same type
    temp_AvPrb <- unique(temp_AvPrb)
      
    if ("STORM_SLAB"  %in%  temp_AvPrb        | "STORM SLABS" %in%  temp_AvPrb) {
      df_AvProb[1,'Count'] <- df_AvProb[1,'Count'] + 1
    }  
    if ("WIND_SLAB"            %in% temp_AvPrb | "WIND SLABS" %in% temp_AvPrb) {
      df_AvProb[2,'Count'] <- df_AvProb[2,'Count'] + 1
    } 
    if ("PERSISTENT_SLAB"      %in% temp_AvPrb | "PERSISTENT SLABS" %in% temp_AvPrb) {
      df_AvProb[3,'Count'] <- df_AvProb[3,'Count'] + 1
    } 
    if ("DEEP_PERSISTENT_SLAB" %in% temp_AvPrb | "DEEP PERSISTENT SLABS" %in% temp_AvPrb) {
      df_AvProb[4,'Count'] <- df_AvProb[4,'Count'] + 1
    } 
    if ("PERSISTENT_SLAB"      %in% temp_AvPrb | "PERSISTENT SLABS" %in% temp_AvPrb | "DEEP_PERSISTENT_SLAB" %in% temp_AvPrb | "DEEP PERSISTENT SLABS" %in% temp_AvPrb) {
      df_AvProb[5,'Count'] <- df_AvProb[5,'Count'] + 1
    } 
    if ("WET_SLAB"             %in% temp_AvPrb | "WET SLABS" %in% temp_AvPrb) {
      df_AvProb[6,'Count'] <- df_AvProb[6,'Count'] + 1
    } 
    if ("LOOSE_WET_AVALANCHE"  %in% temp_AvPrb | "LOOSE WET" %in% temp_AvPrb) {
      df_AvProb[7,'Count'] <- df_AvProb[7,'Count'] + 1
    } 
    if ("LOOSE_DRY_AVALANCHE"  %in% temp_AvPrb | "LOOSE DRY" %in% temp_AvPrb) {
      df_AvProb[8,'Count'] <- df_AvProb[8,'Count'] + 1
    } 
    if ("CORNICE"              %in% temp_AvPrb | "CORNICES" %in% temp_AvPrb) {
      df_AvProb[9,'Count'] <- df_AvProb[9,'Count'] + 1
    } 
  }
  df_AvProb$Perc <- round((df_AvProb$Count / df_AvProb$NumBul) * 100,1)
  return(df_AvProb)
}