#' Creates plot of Avalanche Problems across multiple seasons
#'
#' Creates plot of Avalanche Problems across multiple seasons
#' @param Agency Name of agency (PkCan or AvCan)
#' @param Seasons Range of Seasons to be plotted. i.e. 2012:2015
#' @param Regions Character vector of bulletin regions
#' @param OutputFolder Folder path for output PNG files
#' @param BestDBSourceInt Dataframe with information about best data source DB to be used for query. Default is the BestDBSource dataframe that is included in the package.
#' @param User Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)
#' @param Verbose Switch for printing SQL queries. Default value is FALSE.
#' @param SuppressDBWarnings Switch for turning warnings off. Default value is TRUE.
#' @return PNG file in specified output folder
#'
#' @export

createAvProblemPlotData <- function (Agency, Seasons, Regions, OutputFolder, BestDBSourceInt=BestDBSource, User="", Verbose=F, SuppressDBWarnings=T) 
{
  # start time of processing
  op <- options(digits.secs = 3)
  Time_Start <- Sys.time()
  # create a list that contains data for each region
  #RegionsList <- vector("list", length(Regions))
  
  #for (Index_Region in 1:length(Regions))
  #{
    # Retrieve data to plot
    ## create for loop to createAvProblemStats for each season
    for(Index_Year in 1:length(Seasons))
    {
      # DF for stats for single year
      Tbl_Stats <- createAvProblemStats(Agency, Seasons[Index_Year], Regions)

      # Create tempAlp, tempTln, tempBtl

      tempAlp <- data.frame(Season=Seasons[Index_Year],
                           Region=Regions,
                           NumProb=Tbl_Stats$DPersC[1]+Tbl_Stats$PersC[1]+Tbl_Stats$StormC[1]+Tbl_Stats$WindC[1]+Tbl_Stats$CornC[1]+Tbl_Stats$WetC[1]+Tbl_Stats$LWetC[1]+Tbl_Stats$LDryC[1],
                           PersPl=Tbl_Stats$PersPlC[1], DPers=Tbl_Stats$DPersC[1], Pers=Tbl_Stats$PersC[1], Storm=Tbl_Stats$StormC[1], 
                           Wind=Tbl_Stats$WindC[1], Corn=Tbl_Stats$CornC[1], Wet=Tbl_Stats$WetC[1], LWet=Tbl_Stats$LWetC[1], LDry=Tbl_Stats$LDryC[1])
      
      tempTln <- data.frame(Season=Seasons[Index_Year],
                           Region=Regions,
                           NumProb=Tbl_Stats$DPersC[2]+Tbl_Stats$PersC[2]+Tbl_Stats$StormC[2]+Tbl_Stats$WindC[2]+Tbl_Stats$CornC[2]+Tbl_Stats$WetC[2]+Tbl_Stats$LWetC[2]+Tbl_Stats$LDryC[2],
                           PersPl=Tbl_Stats$PersPlC[2], DPers=Tbl_Stats$DPersC[2], Pers=Tbl_Stats$PersC[2], Storm=Tbl_Stats$StormC[2], 
                           Wind=Tbl_Stats$WindC[2], Corn=Tbl_Stats$CornC[2], Wet=Tbl_Stats$WetC[2], LWet=Tbl_Stats$LWetC[2], LDry=Tbl_Stats$LDryC[2])
      
      tempBtl <- data.frame(Season=Seasons[Index_Year],
                           Region=Regions,
                           NumProb=Tbl_Stats$DPersC[3]+Tbl_Stats$PersC[3]+Tbl_Stats$StormC[3]+Tbl_Stats$WindC[3]+Tbl_Stats$CornC[3]+Tbl_Stats$WetC[3]+Tbl_Stats$LWetC[3]+Tbl_Stats$LDryC[3],
                           PersPl=Tbl_Stats$PersPlC[3], DPers=Tbl_Stats$DPersC[3], Pers=Tbl_Stats$PersC[3], Storm=Tbl_Stats$StormC[3], 
                           Wind=Tbl_Stats$WindC[3], Corn=Tbl_Stats$CornC[3], Wet=Tbl_Stats$WetC[3], LWet=Tbl_Stats$LWetC[3], LDry=Tbl_Stats$LDryC[3])

      # Compile years together 
      if (exists("List_year"))
      { 
        Tbl_Alp <- rbind(Tbl_Alp, tempAlp)
        Tbl_Tln <- rbind(Tbl_Tln, tempTln)
        Tbl_Btl <- rbind(Tbl_Btl, tempBtl)
        List_year <- list(Alp = Tbl_Alp,
                          Tln = Tbl_Tln,
                          Btl = Tbl_Btl)
      }else
      {      
        Tbl_Alp <- tempAlp
        Tbl_Tln <- tempTln
        Tbl_Btl <- tempBtl
        List_year <- list(Alp = tempAlp,
                          Tln = tempTln,
                          Btl = tempBtl)
      }

    } # End of seasons loop

    # Create a list of all seasons for one region
    #RegionsList[Index_Region] <- List_year
    #names(RegionsList) <- Regions
  #} # End of region loop 

  # clean up of variables
  rm(Index_Year, Tbl_Stats)

  # end time of processing
  Time_End <- Sys.time()
  print(Time_End - Time_Start)

  return(List_year)

  # plot AvProblems to output folder
  #plotOneRegionAllProblems(List_year, Regions, OutputFolder)

}  # End of createAvProblemPlot