#' Creates data frame for season plot of avalanche bulletins
#'
#' Creates data frame for season plot of avalanche bulletins
#' @param Bulletin List created with getBulletin() function
#'
#' @return Dataframe with results
#'
#' @export

createBulletinSeasonPlotData <- function(Bulletin){
  # Debugging
  #Bulletin <- getBulletins('AvCan', Seasons = 2010, Regions = 'North Columbia')

  # getBulletins dataframe calls avalanche character for desired date range/year
  DF_Alp <- data.frame(bulletinID = Bulletin$AvProblems$Alp$BULLETIN_ID,
                      AvCh = Bulletin$AvProblems$Alp$CHARACTER)
  DF_Tln <- data.frame(bulletinID = Bulletin$AvProblems$Tl$BULLETIN_ID,
                     AvCh = Bulletin$AvProblems$Tl$CHARACTER)
  DF_Btl <- data.frame(bulletinID = Bulletin$AvProblems$Btl$BULLETIN_ID,
                      AvCh = Bulletin$AvProblems$Btl$CHARACTER)

  # add dates to the dataframe of retrieved avalanche characters

  Dates <- data.frame(Date = as.Date(Bulletin$Bulletins$PUBLISH_DATE),
                      bulletinID = Bulletin$Bulletins$BULLETIN_ID)

  DF_Alp <- merge(Dates, DF_Alp)
  DF_Tln <- merge(Dates, DF_Tln)
  DF_Btl <- merge(Dates, DF_Btl)

  # Tbl for Av characters
  #Tbl_DangerRating <- data.frame(bulletinID = Bulletin$DngRating$Alp$BULLETIN_ID,
  #                               AlpDR = Bulletin$DngRating$Alp$DAY0,
  #                               TlnDR = Bulletin$DngRating$Tl$DAY0,
  #                               BtlDR = Bulletin$DngRating$Btl$DAY0)

  # fixing bug for data.frame that do not have matching lengths
  Tbl_DangerRating <- data.frame(bulletinID = Bulletin$DngRating$Alp$BULLETIN_ID,
                        AlpDR = Bulletin$DngRating$Alp$DAY0)
  Tbl_Tln          <- data.frame(bulletinID = Bulletin$DngRating$Tl$BULLETIN_ID,
                        TlnDR = Bulletin$DngRating$Tl$DAY0)
  Tbl_Btl          <- data.frame(bulletinID = Bulletin$DngRating$Btl$BULLETIN_ID,
                        BtlDR = Bulletin$DngRating$Btl$DAY0)

  Tbl_DangerRating <- merge(Tbl_DangerRating, Tbl_Tln, by = "bulletinID", all = T)
  Tbl_DangerRating <- merge(Tbl_DangerRating, Tbl_Btl, by = "bulletinID", all = T)

  Tbl_AvChart <- data.frame(Date = as.Date(Bulletin$Bulletins$PUBLISH_DATE),
                            bulletinID = Bulletin$Bulletins$BULLETIN_ID,
#                             AlpDR = Bulletin$DngRating$Alp$DAY0,
#                             TlnDR = Bulletin$DngRating$Tl$DAY0,
#                             BtlDR = Bulletin$DngRating$Btl$DAY0,
                            Storm = 0,
                            Pers = 0,
                            DPers = 0,
                            PersPl = 0,
                            Wind = 0,
                            Wet = 0,
                            Corn = 0,
                            LDry = 0,
                            LWet = 0)

  # for loop formating vertical Av character data into horizontal data
  format_getbulletins <- function(elevation, elevDF)
  {
    # elevDF <- DF_Alp
    for (Index in 1:nrow(elevDF)) 
    {
      #Index <- 1
      if (elevDF$AvCh[Index]=="Storm Slabs") {
        Tbl_AvChart$Storm[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Persistent Slabs"){
        Tbl_AvChart$Pers[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Deep Persistent Slabs"){
        Tbl_AvChart$DPers[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Wind Slabs"){
        Tbl_AvChart$Wind[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Wet Slabs"){
        Tbl_AvChart$Wet[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Cornices"){
        Tbl_AvChart$Corn[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Loose Dry"){
        Tbl_AvChart$LDry[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
      if(elevDF$AvCh[Index]=="Loose Wet"){
        Tbl_AvChart$LWet[Tbl_AvChart$Date==elevDF$Date[Index]] <- 1
      }
    }

    # Change column names
    names(Tbl_AvChart)[3:length(names(Tbl_AvChart))] <- paste0(elevation, names(Tbl_AvChart)[3:length(names(Tbl_AvChart))])

    return(Tbl_AvChart)

    }# End of Horizontal format


  # Tbl for 3 elevation bands
  Tbl_Alp <- format_getbulletins("Alp", DF_Alp)
  Tbl_Tln <- format_getbulletins("Tln", DF_Tln)
  Tbl_Btl <- format_getbulletins("Btl", DF_Btl)

  # Merge Alp, Tln, and Btl elevation bands into one table
  Tbl_Combined <- merge(Tbl_Alp,Tbl_Tln, by=c("bulletinID", "Date"), all=T)
  Tbl_Combined <- merge(Tbl_Combined,Tbl_Btl, by=c("bulletinID", "Date"), all=T)
  Tbl_Combined <- merge(Tbl_Combined, Tbl_DangerRating, by=c("bulletinID"), all.x=T)

  # remove 'Bulletin_' from bulletinID column
  # Tbl_Combined$bulletinID <- substr(Tbl_Combined$bulletinID,10,14)

  # Populate the elevPersPl column
  Tbl_Combined$AlpPersPl <- ifelse(Tbl_Combined$AlpPers+Tbl_Combined$AlpDPers >=1,1,0)
  Tbl_Combined$TlnPersPl <- ifelse(Tbl_Combined$TlnPers+Tbl_Combined$TlnDPers >=1,1,0)
  Tbl_Combined$BtlPersPl <- ifelse(Tbl_Combined$BtlPers+Tbl_Combined$BtlDPers >=1,1,0)

  # Sort by date
  Tbl_Combined <- Tbl_Combined[order(Tbl_Combined$Date),]

  Output <- modifyDateColumn(Tbl_Combined)

  return(Output)
} # end of prep_bulletin function


