#' Extracts single avalanche problems and stackes them into a single dataframe
#'
#' Extracts single avalanche problems and stackes them into a single dataframe.
#' This funct5ion was created for Taylor's research in 2018.
#'
#' @param DF Data frame
#' @param AvProb Single or multiple avalanche problem types. Default is complete list with ListAvProblemTypesAbbrev.
#'
#' @examples
#' require(SarpBulletinTools)
#'
#' ## Get data
#' load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))
#' nrow(TblAnalysis)
#'
#' ## Overview of avalanche problem combinations
#' table(TblAnalysis$PROB_COMBINATION)
#'
#' ## Stack single acvalanche problems
#' SingleProbStacked <- extractAndStackSingleAvProblems(TblAnalysis)
#' table(SingleProbStacked$PROB_COMBINATION)
#'
#' @export

extractAndStackSingleAvProblems <- function(DF, AvProb=ListAvProblemTypesAbbrev) {

  for (i in 1:length(AvProb)) {

    ## Extract
    AvProbColumns <- which(substr(names(DF),1, nchar(AvProb[i]))==AvProb[i])
    Temp <- DF[DF$PROB_COMBINATION==AvProb[i], c(1:15, 212, 213, 310, 311, 184:187, AvProbColumns)]

    ## Check if any records
    if(nrow(Temp)>0) {

      ## Rename columns
      cin <- which(substr(names(Temp),1, nchar(AvProb[i]))==AvProb[i])
      names(Temp)[cin] <- substr(names(Temp)[cin], nchar(AvProb[i])+2, length(names(Temp)))

      ## Stack
      if (i==1) {
        Output <- Temp
      } else {
        Output <- rbind(Output, Temp)
      }

    }

  }

  ## Formatting
  Output$PROB_COMBINATION <- factor(Output$PROB_COMBINATION)

  ## Return output
  return(Output)

}
