#' Fixes bulletins region names
#'
#' Fixes bulletin region names
#' @param RegionName Array with bulletin region names.
#' @param Season Array with seasons of the same length as bulletin region.
#' @return Array with fixed bulletin region names.
#' @export
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2017.RData"))
#' summary(Bulletins)
#'
#' table(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)
#'
#' Bulletins$Bulletins$REGION <- fixBulletinRegionNames(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)
#' table(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)
#'
#' @export


fixBulletinRegionNames <- function(RegionName, Season) {

  ## Turn into character
  RegionName <- as.character(RegionName)

  ## Fix South Coast Inland
  RegionName[RegionName=="South Coast - Inland"] <- "South Coast Inland"

  ## Fix Cariboos
  RegionName[RegionName=="Cariboos"] <- "North Columbia - Cariboos"

  ## Fix North Columbias >= 2017
  RegionName[RegionName=="North Columbia" & Season>2016] <- "North Columbia - Monashees & Selkirks"

  ## Turn into factor again
  RegionName <- factor(RegionName)

  return(RegionName)

}
