#' Fixes forecaster names
#'
#' Fixes forecaster names
#' @param Names Array with forecaster names.
#' @return Array with fixed forecaster names.
#' @export
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2017.RData"))
#' summary(Bulletins)
#'
#' table(Bulletins$Bulletins$FORECASTER, Bulletins$Bulletins$AGENCY)
#'
#' Bulletins$Bulletins$FORECASTER <- fixForecasterNames(Bulletins$Bulletins$FORECASTER)
#' table(Bulletins$Bulletins$FORECASTER, Bulletins$Bulletins$AGENCY)
#'
#' @export

fixForecasterNames <- function(Names) {

  Names <- tolower(as.character(Names))
  Names[Names=="ahorvath"] <- "anton horvath"
  Names[Names=="cam_c"] <- "cam campbell"
  Names[Names=="ccampbell"] <- "cam campbell"
  Names[Names=="esharp"] <- "eirik sharp"
  Names[Names=="ghelgeson"] <- "grant helgeson"
  Names[Names=="istorm"] <- "ilya storm"
  Names[Names=="jabbiss"] <- "j abbiss"
  Names[Names=="jeremy.mackenzie"] <- "jeremy mackenzie"
  Names[Names=="jfloyer"] <- "james floyer"
  Names[Names=="jlammers"] <- "joe lammers"
  Names[Names=="mbender"] <- "mark bender"
  Names[Names=="mike.koppang"] <- "mike koppang"
  Names[Names=="mpeter"] <- "matt peter"
  Names[Names=="pgoddard"] <- "penny goddard"
  Names[Names=="pmarshall"] <- "peter marshall"
  Names[Names=="swerner"] <- "shanon werner"
  Names[Names=="triley"] <- "tom riley"
  Names[Names=="tsittling"] <- "tony sittlinger"
  Names[Names=="burke.duncan"] <- "burke duncan"
  Names[Names=="gohm"] <- "gord ohm"
  Names[Names=="peter"] <- "matt peter"
  Names[Names=="slemieux"] <- "stephanie lemieux"
  Names[Names=="bcorrigan"] <- "buck corrigan"
  Names[Names=="jcoulter"] <- "jenn coulter"
  Names[Names=="jminifie"] <- "j minifie"
  Names[Names=="matt.mueller"] <- "matt mueller"
  Names[Names=="mhalik"] <- "m halik"
  Names[Names=="mholmes"] <- "m holmes"
  Names[Names=="rbuhler"] <- "ryan buhler"
  Names[Names=="jsmith"] <- "j smith"
  Names[Names=="wbforecaster"] <- "wb forecaster"
  Names[Names=="cgarritty"] <- "c garritty"
  Names[Names=="mgrist"] <- "m grist"
  Names[Names=="michael.olsthoorn"] <- "michael olsthoorn"
  Names[Names=="shorton"] <- "simon horton"

  Names <- factor(Names)

  return(Names)

}
