#' Formats bulletin object for Moses' analysis.
#'
#' Formats bulletin object for Moses Towell's analysis.
#' This function was created for Moses Towell's research in 2018.
#' @param BulletinObj Bulletin object created by getBulletins() function
#'
#' @examples
#' require(SarpBulletinTools)
#'
#' load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2018.RData"))
#' summary(Bulletins)
#'
#' TblAnalysis <- formatBulletinObjForHzdAnalysis_Moses1(Bulletins)
#'
#' ## You can also you can load TblAnalysis directly from the URL with
#' ## load(url("http://data.avalancheresearch.ca/2018_Analysis_Moses.RData"))
#'
#'
#' table(TblAnalysis$SEASON, TblAnalysis$ELEV)
#'
#' table(TblAnalysis$PROB_COMBINATION, TblAnalysis$ELEV)
#'
#' @export

formatBulletinObjForHzdAnalysis_Moses1 <- function(BulletinObj) {

  ## General transformation
  Output <- formatBulletinObjForHzdAnalysis(BulletinObj,
                                            MissingAvProblemInWideFormat = 0)


  ## Eliminate unwanted forecast regions
  Before <- nrow(Output)
  Output <- Output[Output$REGION == "Glacier",]
  Output$REGION <- factor(Output$REGION)
  After <- nrow(Output)
  print(paste0("Eliminated ", Before - After, " records from non-relevant forecast regions."))


  ## Derived columns: binary, product, sum, diff
  for (Index in 1:length(ListAvProblemTypesAbbrev)) {
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] <- 0
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")][Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MAX")] > 0] <- 1
  }

  ## Properly format likelihood and size as ordered factors
  for (Index in 1:length(ListAvProblemTypesAbbrev)) {

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MIN")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MIN")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MIN")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MIN")][,1]), levels = c(1:9), labels = LevelsLikelihood)

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_TYP")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_TYP")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_TYP")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_TYP")][,1]), levels = c(1:9), labels = LevelsLikelihood)

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MAX")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MAX")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MAX")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_LIKELIHOOD_MAX")][,1]), levels = c(1:9), labels = LevelsLikelihood)

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MIN")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MIN")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MIN")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MIN")][,1]), levels = c(1:9), labels = LevelsSize)

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_TYP")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_TYP")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_TYP")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_TYP")][,1]), levels = c(1:9), labels = LevelsSize)

    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MAX")][(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MAX")] == 0)] <- NA
    Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MAX")] <- ordered(as.array(Output[paste0(ListAvProblemTypesAbbrev[Index], "_SIZE_MAX")][,1]), levels = c(1:9), labels = LevelsSize)

  }

  ## Create problem combinations
  Output$PROB_COMBINATION <- NA
  Output$PROB_NUM <- 0

  for (Index in 1:length(ListAvProblemTypesAbbrev)) {
    Output$PROB_COMBINATION[Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] == 1] <- ifelse(is.na(Output$PROB_COMBINATION[Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] == 1]), ListAvProblemTypesAbbrev[Index], paste(Output$PROB_COMBINATION[Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] == 1], ListAvProblemTypesAbbrev[Index], sep = "_"))
    Output$PROB_NUM[Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] == 1] <- Output$PROB_NUM[Output[paste0(ListAvProblemTypesAbbrev[Index], "_PRES")] == 1] + 1
  }

  Output$PROB_COMBINATION[Output$PROB_NUM == 0] <- "NOPROB"

  Output$PROB_COMBINATION <- factor(Output$PROB_COMBINATION)
  print("Created variable PROB_COMBINATION to indicate combination of problems.")


  ## Return output
  return(Output)

}
