#' Input getBulletins object and return hazard plot info
#'
#' Input getBulletins object and return hazard plot info. This function should not be used anymore!! Use formatBulletinObjForHzdAnalysis() instead!
#' @param Bulletin getBuletins object
#' @return List with result
#'
#' @examples
#'
#' require(SarpGeneral)
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#' require(bulletintools)
#' require(dplyr)
#' require(reshape2)
#'
#' # fetch bulletindata
#' Agency    <- "AvCan"
#' StartDate <- dates("2014-11-01", format="y-m-d")
#' EndDate   <- dates("2015-05-04", format="y-m-d")
#' Region    <- "Kootenay Boundary"
#' Bulletin  <- getBulletins(Agency, StartDate=StartDate, EndDate=EndDate,
#'                           Regions=Region)
#'
#' # select parameters from bulletins$avproblem$elv dataframe
#' input.var <- c('BULLETIN_ID','CHARACTER','LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX',
#'               'SIZE_MIN','SIZE_TYP','SIZE_MAX')
#'
#' hzd.info <- formatBulletinData(data = Bulletin, input.var = input.var)
#' tl <- hzd.info[["Tl"]]
#' unique(tl$BULLETIN_ID)
#'
#' @export

formatGetbulletin <- function(data = Bulletin,
                              input.var = c('BULLETIN_ID','PROBLEM_ID',
                                            'CHARACTER',
                                            'LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX',
                                            'SIZE_MIN','SIZE_TYP','SIZE_MAX')){

  warning("This function should not be used anymore!! Use formatBulletinObjForHzdAnalysis() instead!", immediate. = TRUE)

  ## PARAMETERS
  ## **********
  output.var.avpr <- c("Storm Slabs","Wind Slabs","Cornices","Persistent Slabs","Deep Persistent Slabs","Wet Slabs","Loose Wet","Loose Dry")
  elevation       <- c('Alp', 'Tl', 'Btl')


  ## LOOP FOR EACH ELEVATION BAND
  ## ****************************

  for(elv in 1:3){
    input     <- data$AvProblems[[elv]][,input.var]


    ## COLLAPSE PROBLEMS FOR EACH BULLETIN
    ## -----------------------------------

    input$CHARACTER <- gsub(" ","",input$CHARACTER)

    input %>% select(BULLETIN_ID,CHARACTER:SIZE_MAX) %>% #AS INPUT VARIABLES CHANGE THIS NEEDS TO BE ADJUSTED
      group_by(BULLETIN_ID,CHARACTER) %>%
      mutate(id=1:n()) %>%
      melt(id=c("BULLETIN_ID","id","CHARACTER")) %>%
      dcast(... ~ CHARACTER + variable, value.var="value", fill = 0) %>%
      select(-id) %>%
      ungroup() -> output


    ## STORE DATA FOR EACH ELEVATION BAND
    ## **********************************


    if(elv == 1){data_Alp <- as.data.frame(output)}
    if(elv == 2){data_Tl  <- as.data.frame(output)}
    if(elv == 3){data_Btl <- as.data.frame(output)}

  }


  ## Output table
  ## ************


  tbl_output <- list(Alp = data_Alp,
                     Tl  = data_Tl,
                     Btl = data_Btl)
  return(tbl_output)
}

