#' Gets 7.5 arc second DEM for bulletin region
#'
#' Gets 7.5 arc second DEM for bulletin region
#' @param RegionNames Single or array of bulletin region names. Default is 'All'
#' @param Season Single or array of season for bulletin regions.
#' @param Verbose Switch for printing of query
#'
#' @return Appropriate raster object
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' DEM <- getBulletinRegionDEM(RegionName = "Glacier", Season = 2018)
#' SPDF <- getBulletinRegionGeomSPDF(RegionNames = "Glacier", Season = 2018)
#'
#' ## Default setting with terrain colors
#' plot(SPDF, main="Glacier NP")
#' plotTerrain(DEM, add=T)
#' plot(SPDF, add=T)
#'
#' ## With grey color ramp and 500m elevation steps
#' plot(SPDF, main="Glacier NP")
#' plotTerrain(DEM, WithTerrainCol = F, alpha = 1, ElevStep = 500, add=T)
#' plot(SPDF, border="red", lwd=2, add=T)
#'
#' @export

getBulletinRegionDEM <- function(RegionName, Season, Verbose=F) {

  Query <- paste0("SELECT dem075file FROM bulletin.regions WHERE name='", RegionName, "' AND (season_start <=", Season, ") AND (season_end >=", Season, " OR season_end IS NULL)")
  Tbl <- getRecordsFromQueryBulletinRegionsDB(Query, Verbose=Verbose)

  if (nrow(Tbl>0)) {

    if (nchar(Tbl$dem075file[1]) > 0) {

      load(url(paste0("http://data.avalancheresearch.ca/", Tbl$dem075file[1], ".rda")))
      return(DEM)
    }

    warning("No DEM available for this forecast region!", immediate. = T)
    return(NULL)

  } else {

    warning("Incorrect forecast region specificcation!", immediate. = T)
    return(NULL)

  }

}
