#' Gets overview of daily weather observations available from WeatherDB.
#'
#' Gets overview of daily weather observations available from WeatherDB.
#' @param DateStart Start date of time period. Default value is NA.
#' @param DateEnd End date of time period. Default value is same as DateStart.
#' @return List with summary tables with data frames from each source
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' Overview_All  <- getDailyWxObsFromWxDBOverview()
#' Overview_2016 <- getDailyWxObsFromWxDBOverview(DateStart = "2015-10-01", DateEnd = "2016-05-01")
#'
#' @export

getDailyWxObsFromWxDBOverview <- function(DateStart=NA, DateEnd=DateStart) {

  ## InfoEx
  Query <- "SELECT oper_name, wxsite_name, count(oper_name) as num_obs, Min(date) as first_date, Max(date) as last_date FROM infoex.daily "
  if (!is.na(DateStart)) {Query <- paste(Query, "where date > '", DateStart, "' and date <= '", DateEnd, "' ")}
  Query <- paste(Query, "GROUP BY oper_name, wxsite_name ORDER BY oper_name, wxsite_name")

  InfoEx <- getRecordsFromQueryWxDB(Query)

  ## BCMoTI
  BCMoTI <- NULL

  ## EnvCan
  EnvCan <- NULL

  ## Output
  Output <- list(InfoEx=InfoEx,
                 BCMoTI=BCMoTI,
                 EnvCan=EnvCan)

  return(Output)

}
