#' Gets dataframes what lists number of all available bulletins for different regions and season from best datasource.
#'
#' Gets dataframes what lists number of all available bulletins for different regions and season from best datasource.
#' @return Dataframe with results
#'
#' @export

getNumBulletinsAllAvail <- function() {

  for (Index in 1:nrow(BestDBSource)) {

    TempList <- getNumBulletinsForSeason(BestDBSource$Agency[Index], BestDBSource$Season[Index])

    if (BestDBSource$DB[Index]=="AvalX") {
      Temp <- TempList$AvalX
    } else if (BestDBSource$DB[Index]=="Bulletin") {
      Temp <- TempList$Bulletin
    } else if (BestDBSource$DB[Index]=="HzdWebsite") {
      Temp <- TempList$HzdWebsite
    }

    Temp$AGENCY <- BestDBSource$Agency[Index]
    Temp$SEASON <- BestDBSource$Season[Index]
    Temp$SOURCE <- BestDBSource$DB[Index]

    if (exists("Output")) {
      Output <- rbind(Output, Temp)
    } else {
      Output <- Temp
    }

  }

  return(Output)

}
