#' Gets record from bulletin regions database based on SQL query
#'
#' Gets record from bulletin regions database based on SQL query
#' @param Query Properly formatted SQL query
#' @param ReadOnly Switch for specifiying whether query is sent with read only or read and write credentials.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressDBWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @return Dataframe with result
#'
#' @export

getRecordsFromQueryBulletinRegionsDB <- function(Query, ReadOnly=T, Verbose=F, SuppressDBWarnings=T, MaxNumTries=10) {

  if(Verbose) {cat(Query, ";\n\n")}

  if (SuppressDBWarnings) {options(warn=-1)}

  ## Connect to DB
  DBCon <- tryMultipleTimes(connectToBulletinRegionDB(ReadOnly), MaxNumTries=MaxNumTries)
  Result <- RPostgreSQL::dbSendQuery(DBCon, Query)
  ResultDF <- dbFetch(Result, n=-1)
  dbDisconnect(DBCon)
  rm(Result)

  ## Finish
  if (SuppressDBWarnings) {options(warn=0)}
  rm(DBCon)

  return(ResultDF)

}
