#' Write geometries of bulletin region to bulletin geodatabase.
#'
#' Write geometries of bulletin region to bulletin geodatabase.
#' @param Folder Complete path of folder that contains shape files
#' @param ShpFileName Name of shape file without file extension (i.e., shp)
#' @param SeasonStart Season when the geometries to be imported where first used.
#' @param SeasonEnd Season when the geometries to be imported where last used.
#' @param Agency Name of agency whose bulletin regions are imported.
#'
#' @examples
#'
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' Folder <- "C:\\Temp\\bulletinregions\\shp"
#' ShpFileName <- "16_BulletinRegions_CAC"
#'
#' importBulletinRegionGeom(Folder, ShpFileName, SeasonStart=2017, SeasonEnd=2018)
#'
#' @export


importBulletinRegionGeom <- function(Folder, ShpFileName, SeasonStart=NA, SeasonEnd=NA, Agency=NA) {

  ## Read shp file
  SPDF_BulletinRegion <- rgdal::readOGR(Folder, ShpFileName)

  # plot(SPDF_BulletinRegion)
  # View(SPDF_BulletinRegion@data)

  names(SPDF_BulletinRegion@data) <- tolower(names(SPDF_BulletinRegion@data))

  ## Modify dataframe
  # SPDF_BulletinRegion@data$name <- SPDF_BulletinRegion@data$name
  # SPDF_BulletinRegion@data <- deleteDFColumnsByName(SPDF_BulletinRegion@data, "Name")

  SPDF_BulletinRegion@data$description <- SPDF_BulletinRegion@data$descriptio
  SPDF_BulletinRegion@data <- deleteDFColumnsByName(SPDF_BulletinRegion@data, "descriptio")

  SPDF_BulletinRegion@data$uuid <- NA
  for (Index in 1:nrow(SPDF_BulletinRegion@data)) {
    SPDF_BulletinRegion@data$uuid[Index] <- createUuid()
  }

  ## Add parameter values if provided
  if (!is.na(SeasonStart)) SPDF_BulletinRegion@data$season_start <- SeasonStart
  if (!is.na(SeasonEnd)) SPDF_BulletinRegion@data$season_end <- SeasonEnd
  if (!is.na(Agency)) SPDF_BulletinRegion@data$agency <- Agency

  ## Write to database
  writeBulletinRegionGeomToDB(SPDF_BulletinRegion)

}

