#' Modifies date column to create standard season of dates.
#'
#' Modifies date column to create standard season of dates.
#' @param SeasonPlotData  Data frame from getBulletins
#'
#' @return Dataframe with Date column from Nov 1 to May 15 of the Av Season
#'
#' @export

modifyDateColumn <- function(SeasonPlotData)
  
{
  
  warning('This function will be deleted in the future!', immediate. = T)
  
  # 1.a. create a blank copy of the input dataframe
  Output <- SeasonPlotData[0,]

  # 1.b. call start and end date
  nov1 <- "-11-01"
  may15 <- "-05-15"
  # 2. for every DatePublished
  for(Index_Day in 1:(nrow(SeasonPlotData)))
  {
    # 3. if DatePublished is greater than the start date OR less than the end date
    if(substr(SeasonPlotData$Date[Index_Day],5,10) >= nov1 ||
       substr(SeasonPlotData$Date[Index_Day],5,10) <= may15)
    {
      # 4. add a date to the UnModified Date column
      Output[nrow(Output)+1,] <- (SeasonPlotData)[Index_Day,]
    }

  }
  rm(Index_Day)

  # Create desired date column in desired format

  return(Output)
}
