#' Plot distribution of avalanche problem distribution parameter.
#'
#' Plot distribution of avalanche problem distribution parameter.
#' @param AvProblems DF with set of avalanche problems
#' @param Title Title of plot.
#' @param Percent Switch whether distribution should be shows as percent or counts. Default value is F.
#'
#' @examples
#' require(SarpBulletinToolsPrivate)
#' require(SarpBulletinTools)
#'
#' ## Retrieving data
#' Bulletins_Gl2012 <- getBulletins(Agency="PkCan", Seasons=2012, Regions="Glacier")
#' AvProblems <- Bulletins_Gl2012$AvProblems$Alp[Bulletins_Gl2012$AvProblems$Alp$CHARACTER=="Persistent Slabs",]
#'
#' ## Plot distribution of distribution parameter
#' plotAvProbDistribution(AvProblems, Title="Persistent Slabs")
#'
#' @export

plotAvProbDistribution <- function(AvProblems, Title, Percent=F) {

  Count <- table(AvProblems$DISTRIBUTION)

  if (Percent) {
    ylab <- "Percent"
    ylim <- c(0,100)
    Count <- Count/sum(Count)*100
  } else {
    ylab <- "Count"
    ylim <- c(0, max(Count))
  }

  plot(NULL, xaxt="n", ylab=ylab, xlab="Distribution", xlim=c(1,length(LevelsDistribution)), ylim=ylim, main=Title)
  lines(Count, type="b")
  abline(v=median(as.numeric(AvProblems$DISTRIBUTION)), lty=2)
  axis(1, at=c(1:length(LevelsDistribution)), labels=LevelsDistribution)
  box()
  mtext(paste0("(n=", nrow(AvProblems), ")"), side = 3, adj=1, cex=0.75)
  if(nrow(AvProblems)==0) {
    text(length(LevelsDistribution)/2+0.5, max(ylim)/2, "No problem records available!", col="red", adj=0.5, cex=0.75)
  } else if (sum(!is.na(AvProblems$DISTRIBUTION))==0) {
    text(length(LevelsDistribution)/2+0.5, max(ylim)/2, "No distribution values available!", col="red", adj=0.5, cex=0.75)
  }

}
