#' Prepares infoEX data for Mock and Birkeland 2000 classification
#'
#' Prepares infoEX data for Mock and Birkeland 2000 classification
#' @param wxObs Output from getDailyWxObsFromWxDB() 
#' @return Dataframe with result
#'
#' @examples
#' ## DEPENDENCIES
#' ## ************
#' 
#' 
#' require(SarpGeneral)
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#' 
#' 
#' ## CALL DATA
#' ## *********
#' 
#' 
#' wx_db <- getDailyWxObsFromWxDBOverview()
#' 
#' wxObs <- getDailyWxObsFromWxDB(Source = 'InfoEx',
#'                                OperName = wx_db$InfoEx$oper_name[1],
#'                                WxSiteName = wx_db$InfoEx$wxsite_name[1])
#' ## PREP DATA
#' ## *********
#' 
#' 
#' wx.data <- prepareWxDataInfoEX(wxObs)
#' 
#' 
#' ## Mock and Birkeland classification
#' ## *********************************
#' 
#' 
#' deriveSnowClimateClass_MockBirkeland2000(wx.data)
#' 
#' @export

prepareWxDataInfoEX <- function(wxObs){
  wxObs$AvgTemp <- (wxObs$temp_max + wxObs$temp_min) / 2
  wxObs$Precip  <- wxObs$hn24*10 + wxObs$rainfall
  
  ### select desired variables
  wx.data        <- wxObs[,c('date','AvgTemp','rainfall','hn24','Precip','hs')]
  
  ### standarize names
  names(wx.data) <- c( "Date", "AvgTemp", "Rain", "Hn24", "Precip", "Hs")
  
  ### change date class to work with chron()
  wx.data$Date   <- dates(as.character(wx.data$Date), format="y-m-d")
  
  return(wx.data)
}
