#' Standarize bulletin region names.
#'
#' Standarize bulletin region names
#' @param BulletinRegionNameArrays List of bulletin region names
#' @param ToWhichName Switch for specify which names from the list in BulletinRegionNamesEquivalency should be used. Can be 'First' (default) or 'Last'.
#' @param AsFactor Switch that determines whether output array is turned into a factor. Default value is TRUE.
#' @return Standarized list of bulletin region names
#' @export
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' ## With using the first names (default)
#' Region <- "South Coast - Inland"
#' (Test <- addEquivalentBulletinRegionNames(Region))
#' standardizeBulletinRegionNames(Test)
#'
#' ## With using the last names
#' Region <- "South Coast - Inland"
#' (Test <- addEquivalentBulletinRegionNames(Region))
#' standardizeBulletinRegionNames(Test, ToWhichName = "Last")
#'
#' ## Without turning it into a factor
#' Region <- "South Coast - Inland"
#' (Test <- addEquivalentBulletinRegionNames(Region))
#' standardizeBulletinRegionNames(Test, AsFactor = F)
#'
#' @export


standardizeBulletinRegionNames <- function(BulletinRegionNameArray, ToWhichName="First", AsFactor=T) {

  warning("Do not use this function anymore! Use fixBulletinRegionNames() instead.", immediate. = T)

  ## Check
  ToWhichName <- tolower(ToWhichName)
  if (!(ToWhichName=="first" | ToWhichName=="last")) {
    stop("The value for ToWhichName needs to be either 'First' or 'Last'!")
  }

  ## Turn potential factor into character array
  BulletinRegionNameArray <- as.character(BulletinRegionNameArray)

  ## List of unique names
  ListBulletinRegionNames <- unique(BulletinRegionNameArray)

  ## Loop of bulletin region names
  for (RegionIndex in 1:length(ListBulletinRegionNames)) {

    ## Looop over list of bulletion region equivalency
    for (ListIndex in 1:length(BulletinRegionNamesEquivalency)) {

      if (ListBulletinRegionNames[RegionIndex] %in% BulletinRegionNamesEquivalency[[ListIndex]]) {

        if (ToWhichName=="first") {
          BulletinRegionNameArray[BulletinRegionNameArray %in% BulletinRegionNamesEquivalency[[ListIndex]]] <- BulletinRegionNamesEquivalency[[ListIndex]][1]
        } else {
          BulletinRegionNameArray[BulletinRegionNameArray %in% BulletinRegionNamesEquivalency[[ListIndex]]] <- BulletinRegionNamesEquivalency[[ListIndex]][length(BulletinRegionNamesEquivalency[[ListIndex]])]
        }

      }

    }

  }

  ## Turns into factor
  if(AsFactor) {
    BulletinRegionNameArray <- factor(BulletinRegionNameArray)
  }

  ## Return
  return(BulletinRegionNameArray)

}
