#' Prints bulletin summary
#'
#' Prints bulletin summary
#' @param Bulletins Object of type Bulletins
#' @param Format Switch for short or long format
#'
#' @examples
#' require(SarpBulletinTools)
#' require(SarpBulletinToolsPrivate)
#'
#' ## Summary for single bulletin
#' Agency <- "PkCan"
#' Date <- "2014-12-01"
#' Region <- "Jasper"
#'
#' Bulletin <- getBulletins(Agency, StartDate=Date, Regions=Region)
#' summary(Bulletin)
#'
#' ## Summary for multiple bulletins
#' Agency <- "PkCan"
#' Seasons <- c(2014:2015)
#' Regions <- c("Jasper", "Glacier")
#'
#' Bulletins <- getBulletins(Agency, Seasons=Seasons, Regions=Regions)
#' summary(Bulletins)
#'
#' @export

summary.Bulletins <- function (Bulletins, Format="short") {


  ## Internal function for creating archive hyperlink!
  createBulletinHyperlink <- function(TblBulletin) {

    if(TblBulletin$AGENCY=="AvCan") {

      string <- "http://www.avalanche.ca/forecasts/archives/"
      string <- paste0(string, gsub(" ", "-", tolower(TblBulletin$REGION)), "/")
      string <- paste0(string, convertDateToSQL(TblBulletin$VALID_UNTIL, Quotes = FALSE))

      string <- paste0(string, " (BETA!)")

    } else {

      string <- "Not available yet."

    }

    return(string)

  }



  if(nrow(Bulletins$Bulletins)==0) {

    cat(paste0("\n",
               "Summary of bulletin variable\n",
               "****************************\n",
               "No bulletin available\n",
               "\n"))

  } else if(nrow(Bulletins$Bulletins)==1 & tolower(Format)=="short") {

    cat(paste0("\n",
               "Summary of bulletin variable with single bulletin\n",
               "*************************************************\n",
               "Agency: ", Bulletins$Bulletins$AGENCY, "\n",
               "Region: ", Bulletins$Bulletins$REGION, "\n",
               "Published: ", convertDateToSQL(Bulletins$Bulletins$PUBLISH_DATE, Quotes = FALSE), " ", Bulletins$Bulletins$PUBLISH_TIME, "\n",
               "Valid Until: ", convertDateToSQL(Bulletins$Bulletins$VALID_UNTIL, Quotes = FALSE), "\n",
               "\n",
               "Avalanche Problems\n",
               "ALP: ", paste(Bulletins$AvProblems$Alp$CHARACTER, collapse = ", "), "\n",
               "TL : ", paste(Bulletins$AvProblems$Tl$CHARACTER, collapse = ", "), "\n",
               "BTL: ", paste(Bulletins$AvProblems$Btl$CHARACTER, collapse = ", "), "\n",
               "\n",
               "Danger Ratings\n",
               "ALP: ", Bulletins$DngRating$Alp$DAY0[1], " - ", Bulletins$DngRating$Alp$DAY1[1], " - ",Bulletins$DngRating$Alp$DAY2[1], " - ",Bulletins$DngRating$Alp$DAY3[1], "\n",
               "TL : ", Bulletins$DngRating$Tl$DAY0[1], " - ", Bulletins$DngRating$Tl$DAY1[1], " - ",Bulletins$DngRating$Tl$DAY2[1], " - ",Bulletins$DngRating$Tl$DAY3[1], "\n",
               "BTL: ", Bulletins$DngRating$Btl$DAY0[1], " - ", Bulletins$DngRating$Btl$DAY1[1], " - ",Bulletins$DngRating$Btl$DAY2[1], " - ",Bulletins$DngRating$Btl$DAY3[1], "\n",
               "\n"))

  } else if(nrow(Bulletins$Bulletins)==1 & tolower(Format)=="long") {

    cat(paste0("\n",
               "Summary of bulletin variable with single bulletin\n",
               "*************************************************\n",
               "Agency: ", Bulletins$Bulletins$AGENCY, "\n",
               "BulletinID: ", Bulletins$Bulletins$BULLETIN_ID, "\n",
               "Forecaster: ", Bulletins$Bulletins$FORECASTER, "\n",
               "Region: ", Bulletins$Bulletins$REGION, "\n",
               "Published: ", convertDateToSQL(Bulletins$Bulletins$PUBLISH_DATE, Quotes = FALSE), " ", Bulletins$Bulletins$PUBLISH_TIME, "\n",
               "Valid Until: ", convertDateToSQL(Bulletins$Bulletins$VALID_UNTIL, Quotes = FALSE), "\n",
               "Bulletin link: ", createBulletinHyperlink(Bulletins$Bulletins), "\n",
               "\n",
               "Avalanche Problems\n",
               "ALP: ", paste(Bulletins$AvProblems$Alp$CHARACTER, collapse = ", "), "\n",
               "TL : ", paste(Bulletins$AvProblems$Tl$CHARACTER, collapse = ", "), "\n",
               "BTL: ", paste(Bulletins$AvProblems$Btl$CHARACTER, collapse = ", "), "\n",
               "\n",
               "Danger Ratings\n",
               "ALP: ", Bulletins$DngRating$Alp$DAY0[1], " - ", Bulletins$DngRating$Alp$DAY1[1], " - ",Bulletins$DngRating$Alp$DAY2[1], " - ",Bulletins$DngRating$Alp$DAY3[1], "\n",
               "TL : ", Bulletins$DngRating$Tl$DAY0[1], " - ", Bulletins$DngRating$Tl$DAY1[1], " - ",Bulletins$DngRating$Tl$DAY2[1], " - ",Bulletins$DngRating$Tl$DAY3[1], "\n",
               "BTL: ", Bulletins$DngRating$Btl$DAY0[1], " - ", Bulletins$DngRating$Btl$DAY1[1], " - ",Bulletins$DngRating$Btl$DAY2[1], " - ",Bulletins$DngRating$Btl$DAY3[1], "\n",
               "\n"))

  } else if(nrow(Bulletins$Bulletins)==1) {

    stop("Parameter 'Format' specified incorrectly! Can only taker 'short' (default) or 'long'.")

  } else {

    cat(paste0("\n",
               "Summary of bulletin variable with multiple bulletins\n",
               "****************************************************\n",
               "Number of bulletins: ", nrow(Bulletins$Bulletins), "\n",
               "First publish date: ", convertDateToSQL(min(Bulletins$Bulletins$PUBLISH_DATE), Quotes = FALSE), "\n",
               "Last publish date: ", convertDateToSQL(max(Bulletins$Bulletins$PUBLISH_DATE), Quotes = FALSE), "\n",
               "Region(s): ", paste(levels(Bulletins$Bulletins$REGION), collapse = ", "), "\n",
               "\n",
               "Number of alpine avalanche problems: ", nrow(Bulletins$AvProblems$Alp), "\n",
               "Number of treeline avalanche problems: ", nrow(Bulletins$AvProblems$Tl), "\n",
               "Number of below treeline avalanche problems: ", nrow(Bulletins$AvProblems$Btl), "\n",
               "\n"))

  }

}
