% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateHzdChartCountRasterPoints.R
\name{calculateHzdChartCountRasterPoints}
\alias{calculateHzdChartCountRasterPoints}
\title{Calculates raster points for plotting raster in hazard chart with counts or percentages of avalanche problems.}
\usage{
calculateHzdChartCountRasterPoints(AvProblems, Shape = "square",
  NumPoints = 50, OutputRaster = F, Percent = F,
  IDCol = "PROBLEM_ID", SuppressWarnings = T)
}
\arguments{
\item{AvProblems}{DF with avalanche problems}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' or 'square' (default).}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{OutputRaster}{Switch for specifying whether output should be dataframe or raster. Default value is F.}

\item{Percent}{Switch whether raster values should be percentages instead of counts. Default value is F.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}
}
\description{
Calculates raster points for plotting raster in hazard chart with counts or percentages.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

Bulletins_BYK <- getBulletins(Agency="PkCan", Seasons=2015, Regions="Banff, Yoho and Kootenay")
AlpAvProb_BYK <- Bulletins_BYK$AvProblems$Alp

RasterPoints <- calculateHzdChartCountRasterPoints(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Wind Slabs",], Shape = "Square")
RasterCount <- calculateHzdChartCountRasterPoints(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Wind Slabs",], Shape = "Square", OutputRaster=T)
RasterPerc <- calculateHzdChartCountRasterPoints(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Wind Slabs",], Shape = "Square", OutputRaster=T, Percent=T)

}
