% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countAvProb.R
\name{countAvProb}
\alias{countAvProb}
\title{Returns a count of avalanche problem prevalance from a getBulletins() object}
\usage{
countAvProb(Bulletin, Elevation = "ALP")
}
\arguments{
\item{Bulletin}{a getBulletins() object}

\item{Elevation}{defaults to Alpine. Options: 'ALP', 'TL', or 'BTL'}
}
\description{
Returns a count of avalanche problem prevalance from a getBulletins() object
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

Operation <- "AvCan"
Season <- 2015
Region <- "Sea-to-Sky"

## Entire Season - alpine elevation band
Bulletin <- getBulletins(Agency=Operation, Seasons=Season, Regions=Region)

countAvProb(Bulletin, Elevation = 'ALP')

}
