% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createAvProblemPlotData.R
\name{createAvProblemPlotData}
\alias{createAvProblemPlotData}
\title{Creates plot of Avalanche Problems across multiple seasons}
\usage{
createAvProblemPlotData(Agency, Seasons, Regions, OutputFolder,
  BestDBSourceInt = BestDBSource, User = "", Verbose = F,
  SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{Seasons}{Range of Seasons to be plotted. i.e. 2012:2015}

\item{Regions}{Character vector of bulletin regions}

\item{OutputFolder}{Folder path for output PNG files}

\item{BestDBSourceInt}{Dataframe with information about best data source DB to be used for query. Default is the BestDBSource dataframe that is included in the package.}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{Verbose}{Switch for printing SQL queries. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
PNG file in specified output folder
}
\description{
Creates plot of Avalanche Problems across multiple seasons
}
