% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDRCTreeAndValidate.R
\name{createDRCTreeAndValidate}
\alias{createDRCTreeAndValidate}
\title{Creates and validates conditional inference trees (ctree from the party package) for danger ratings}
\usage{
createDRCTreeAndValidate(TreeFormula, TrainData, TestData = TrainData)
}
\arguments{
\item{TreeFormula}{Formula for tree as string}

\item{TrainData}{Data frame with training dataset}

\item{TestData}{Data frame with test dataset (default is training dataset)}
}
\value{
List with tree and performance measures
}
\description{
Creates and validates conditional inference trees (ctree from the party package) for danger ratings.
This function was created for Taylor Clark's research in 2018.
}
\examples{
require(SarpBulletinTools)

load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))
nrow(TblAnalysis)

## Extract assessments with strom slabs only
Tbl <- TblAnalysis[TblAnalysis$ PROB_COMBINATION=="STORM",c("DAY0", "STORM_LIKELIHOOD_TYP", "STORM_SIZE_TYP")]
names(Tbl) <- c("DR", "LH", "SZ")
summary(Tbl)

## Split into training and test dataset
Data <- splitDFTrainTest(Tbl)

## Create ctree model
TreeFormula <- "DR ~ LH + SZ"
Model <- createDRCTreeAndValidate(TreeFormula = TreeFormula, TrainData = Data$train, TestData = Data$test)

## Plot tree
plot(Model$CTree)

## Show paths and final rules for each of the terminal nodes
View(Model$PathsRules)

## Show perforamce measures
Model$ConfMatrix
Model$Acc
Model$AccPlusOne
Model$kappa
Model$mRoc.value

}
