% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractAndStackSingleAvProblems.R
\name{extractAndStackSingleAvProblems}
\alias{extractAndStackSingleAvProblems}
\title{Extracts single avalanche problems and stackes them into a single dataframe}
\usage{
extractAndStackSingleAvProblems(DF, AvProb = ListAvProblemTypesAbbrev)
}
\arguments{
\item{DF}{Data frame}

\item{AvProb}{Single or multiple avalanche problem types. Default is complete list with ListAvProblemTypesAbbrev.}
}
\description{
Extracts single avalanche problems and stackes them into a single dataframe.
This funct5ion was created for Taylor's research in 2018.
}
\examples{
require(SarpBulletinTools)

## Get data
load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))
nrow(TblAnalysis)

## Overview of avalanche problem combinations
table(TblAnalysis$PROB_COMBINATION)

## Stack single acvalanche problems
SingleProbStacked <- extractAndStackSingleAvProblems(TblAnalysis)
table(SingleProbStacked$PROB_COMBINATION)

}
