% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFromBulletinObj.R
\name{extractFromBulletinObj}
\alias{extractFromBulletinObj}
\title{Extracts bulletins from Bulletins object.}
\usage{
extractFromBulletinObj(BulletinObj, ByIndex = NA, ByBulletinID = NA)
}
\arguments{
\item{BulletinObj}{Object of type Bulletins (generally created by getBulletins())}

\item{ByIndex}{Index of bulletin(s) to be extracted in BulletinObj$Bulletins dataframe.}

\item{ByBulletinID}{BulletinID of bulletins to be extracted.}
}
\value{
Object of type Bulletins
}
\description{
Extracts bulletins from Bulletins object by index or BULLETIN_ID.
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

Bulletins <- getBulletins("AvCan", Seasons=2017)

for (Index in 1:4) {
 SingleBulletin <- extractFromBulletinObj(Bulletins, ByIndex = Index)
 summary(SingleBulletin)
}

}
