% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixBulletinRegionNames.R
\name{fixBulletinRegionNames}
\alias{fixBulletinRegionNames}
\title{Fixes bulletins region names}
\usage{
fixBulletinRegionNames(RegionName, Season)
}
\arguments{
\item{RegionName}{Array with bulletin region names.}

\item{Season}{Array with seasons of the same length as bulletin region.}
}
\value{
Array with fixed bulletin region names.
}
\description{
Fixes bulletin region names
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2017.RData"))
summary(Bulletins)

table(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)

Bulletins$Bulletins$REGION <- fixBulletinRegionNames(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)
table(Bulletins$Bulletins$REGION, Bulletins$Bulletins$SEASON)

}
