% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatBulletinObjForHzdAnalysis.R
\name{formatBulletinObjForHzdAnalysis}
\alias{formatBulletinObjForHzdAnalysis}
\title{Formats bulletin object for hazard analysis.}
\usage{
formatBulletinObjForHzdAnalysis(BulletinObj, Format = "wide",
  ElevBands = c("Alp", "Tl", "Btl"), AvProbColIncluded = NA,
  MissingAvProblemInWideFormat = NA, EliminateEmptyRecords = TRUE,
  AddDngRatingPrevDay = FALSE, AddDngRatingOtherElev = FALSE,
  Verbose = TRUE)
}
\arguments{
\item{BulletinObj}{Bulletin object created by getBulletins() function}

\item{Format}{Format of output dataframe. Either 'wide' (default) with one record for each elevation band and avalanche problems in different columns or 'long' with avalanche problems for each elevant band stacked.}

\item{ElevBands}{What elevation band to be included. Default is c("Alp", "Tl", "Btl")}

\item{AvProbColIncluded}{What avalanche problme columns to be included. NA (default) includes all.}

\item{MissingAvProblemInWideFormat}{Specifies how missing avalanche problem values are handled. NA (default) does nothing and 0 fills NA with 0.}

\item{EliminateEmptyRecords}{Switch for eliminating completely empty records (no danger rating, no av problems) in wide format.}

\item{AddDngRatingPrevDay}{Switch for adding danger rating DAY0 of previous day. Default=FALSE}

\item{AddDngRatingOtherElev}{Switch for adding danger rating DAY0 of other elevation bands. Default=FALSE}

\item{Verbose}{Switch for turning user feedback on/off.}
}
\value{
Dataframe with reformatted avalanche problem information
}
\description{
Formats bulletin object for hazard analysis.
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

## SINGLE BULLETIN
## ***************

Agency <- "AvCan"
Region <- "Kootenay Boundary"
StartDate <- dates("2014-12-18", format="y-m-d")
BulletinObj <- getBulletins(Agency, StartDate=StartDate, Regions=Region)
summary(BulletinObj)

BulletinAnalysis1 <- formatBulletinObjForHzdAnalysis(BulletinObj)
BulletinAnalysis2 <- formatBulletinObjForHzdAnalysis(BulletinObj, MissingAvProblemInWideFormat = 0)
BulletinAnalysis3 <- formatBulletinObjForHzdAnalysis(BulletinObj, AvProbColIncluded = c("LIKELIHOOD_MAX", "SIZE_MAX"))
BulletinAnalysis4 <- formatBulletinObjForHzdAnalysis(BulletinObj, AvProbColIncluded = c("LIKELIHOOD_MAX", "SIZE_MAX"), MissingAvProblemInWideFormat = 0)

## MULTIPLE BULLETINS
## ******************

Agency <- "AvCan"
Season <- 2010

## Get bulletin data for a season
Bulletins <- getBulletins(Agency=Agency, Seasons=Season)
summary(Bulletins)

## Format bulletin data for analysis
ForAnalysis <- formatBulletinObjForHzdAnalysis(Bulletins)

## TESTING FOR CONSISTENCY
## ***********************
ElevBand <- "Alp"

## Number of bulletin records
nrow(Bulletins$DngRating[[ElevBand]])
nrow(ForAnalysis[ForAnalysis$ELEV==ElevBand,])
# -> it is possible that the analysis DF has more. The difference should be made up by the number of NA danger ratings (see next comparison)

## Number of NA danger ratings
sum(is.na(Bulletins$DngRating[[ElevBand]]$DAY0))
sum(is.na(ForAnalysis[ForAnalysis$ELEV==ElevBand,]$DAY0))
# -> it is possible that the analysis DF has more than the original bulletin object (e.g., av problems that were characterized for a elevation band where there is not danger rating.)

## Distribution of danger ratings
table(Bulletins$DngRating[[ElevBand]]$DAY0)
table(ForAnalysis[ForAnalysis$ELEV==ElevBand,]$DAY0)

## Distribution of avalanche problems
table(Bulletins$AvProblems[[ElevBand]]$CHARACTER)
sum(!is.na(ForAnalysis$DPERS_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$PERS_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$STORM_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$WIND_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$CORN_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$LDRY_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$WET_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
sum(!is.na(ForAnalysis$LWET_PROBLEM_ID[ForAnalysis$ELEV==ElevBand]))
# -> it is possible to have fewer avalanche problems in analaysis DF (e.g., elimination of secondary problems of same problem type during formatting). Messages during formatting and comparison should be consistent.

}
