% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatBulletinObjForHzdAnalysis_Taylor1.R
\name{formatBulletinObjForHzdAnalysis_Taylor1}
\alias{formatBulletinObjForHzdAnalysis_Taylor1}
\title{Formats bulletin object for Taylor's analysis.}
\usage{
formatBulletinObjForHzdAnalysis_Taylor1(BulletinObj,
  RareProbCombThreshold = 10, NumForecastsThreshold = 50)
}
\arguments{
\item{BulletinObj}{Bulletin object created by getBulletins() function}

\item{RareProbCombThreshold}{Minimum number of cases of avalanche problem combination needed to be kept in dataframe. Default is 10.}

\item{NumForecastsThreshold}{Minimum number of forecasts a forecaster needs in the dataset to be included. Defaut is 50.}
}
\description{
Formats bulletin object for Taylor Clarke's analysis.
This function was created for Taylor Clarke's research in 2018.
}
\examples{
require(SarpBulletinTools)

load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2017.RData"))
summary(Bulletins)

TblAnalysis <- formatBulletinObjForHzdAnalysis_Taylor1(Bulletins)

## The formatting takes a bit of time due to computations for the additional danger rating columns.
## To avoid the waiting time, you can load TblAnalysis directly with
## load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))


table(TblAnalysis$REGION, TblAnalysis$SEASON)

table(TblAnalysis$PROB_COMBINATION, TblAnalysis$ELEV)
table(TblAnalysis$PROB_COMBINATION, TblAnalysis$MTNRANGE)

}
