% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatGetbulletin.R
\name{formatGetbulletin}
\alias{formatGetbulletin}
\title{Input getBulletins object and return hazard plot info}
\usage{
formatGetbulletin(data = Bulletin, input.var = c("BULLETIN_ID",
  "PROBLEM_ID", "CHARACTER", "LIKELIHOOD_MIN", "LIKELIHOOD_TYP",
  "LIKELIHOOD_MAX", "SIZE_MIN", "SIZE_TYP", "SIZE_MAX"))
}
\arguments{
\item{Bulletin}{getBuletins object}
}
\value{
List with result
}
\description{
Input getBulletins object and return hazard plot info. This function should not be used anymore!! Use formatBulletinObjForHzdAnalysis() instead!
}
\examples{

require(SarpGeneral)
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)
require(bulletintools)
require(dplyr)
require(reshape2)

# fetch bulletindata
Agency    <- "AvCan"
StartDate <- dates("2014-11-01", format="y-m-d")
EndDate   <- dates("2015-05-04", format="y-m-d")
Region    <- "Kootenay Boundary"
Bulletin  <- getBulletins(Agency, StartDate=StartDate, EndDate=EndDate,
                          Regions=Region)

# select parameters from bulletins$avproblem$elv dataframe
input.var <- c('BULLETIN_ID','CHARACTER','LIKELIHOOD_MIN','LIKELIHOOD_TYP','LIKELIHOOD_MAX',
              'SIZE_MIN','SIZE_TYP','SIZE_MAX')

hzd.info <- formatBulletinData(data = Bulletin, input.var = input.var)
tl <- hzd.info[["Tl"]]
unique(tl$BULLETIN_ID)

}
