% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletinDBSize.R
\name{getBulletinDBSize}
\alias{getBulletinDBSize}
\title{Get size of bulletin database}
\usage{
getBulletinDBSize(Agency, DBFormat = "AvalX", User = "", Verbose = F,
  SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency}

\item{DBFormat}{Name of database type. Needs to be either 'AvalX' (default), 'Bulletin' or 'HzdWebsite'}

\item{User}{Name of user}

\item{Verbose}{Switch for printing of query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
Size in MB
}
\description{
Get size of bulletin database.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

DB_Size <- getBulletinDBSize("PkCan", "AvalX")
DB_Size <- getBulletinDBSize("AvCan", "HzdWebsite")

}
