% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletinIds.R
\name{getBulletinIds}
\alias{getBulletinIds}
\title{Gets list of bulletin ID with source database information.}
\usage{
getBulletinIds(Agency, Seasons = NA, StartDate = NA,
  EndDate = StartDate, Regions = "All",
  BestDBSourceInt = BestDBSource, User = "",
  SeasonType = "Operation", Verbose = F, SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{Seasons}{List of seasons to be included in query.}

\item{StartDate}{Either publishing date of requested bulletin id or start date for time period if EndDate is provided as well.}

\item{EndDate}{End date for time period of requested bulletin ids.}

\item{Regions}{Name of bulletin region}

\item{BestDBSourceInt}{Dataframe with information about best data source DB to be used for query. Default is the BestDBSource dataframe that is included in the package.}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{SeasonType}{Parameter passed on to deriveAvSeasonInfo() from SARPGeneral package to specify start and end date of a season. Values are 'Operation' (Dec. 15 to Apr. 15) (default) or 'AvYear' (Oct. 1 to Sept. 30).}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
Dataframe with result
}
\description{
Gets list of bulletin ID with source database information.
}
