% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletinRegionDEM.R
\name{getBulletinRegionDEM}
\alias{getBulletinRegionDEM}
\title{Gets 7.5 arc second DEM for bulletin region}
\usage{
getBulletinRegionDEM(RegionName, Season, Verbose = F)
}
\arguments{
\item{Season}{Single or array of season for bulletin regions.}

\item{Verbose}{Switch for printing of query}

\item{RegionNames}{Single or array of bulletin region names. Default is 'All'}
}
\value{
Appropriate raster object
}
\description{
Gets 7.5 arc second DEM for bulletin region
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

DEM <- getBulletinRegionDEM(RegionName = "Glacier", Season = 2018)
SPDF <- getBulletinRegionGeomSPDF(RegionNames = "Glacier", Season = 2018)

## Default setting with terrain colors
plot(SPDF, main="Glacier NP")
plotTerrain(DEM, add=T)
plot(SPDF, add=T)

## With grey color ramp and 500m elevation steps
plot(SPDF, main="Glacier NP")
plotTerrain(DEM, WithTerrainCol = F, alpha = 1, ElevStep = 500, add=T)
plot(SPDF, border="red", lwd=2, add=T)

}
