% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletinRegionGeomSPDF.R
\name{getBulletinRegionGeomSPDF}
\alias{getBulletinRegionGeomSPDF}
\title{Gets bulletin region geometry as spatial dataframe}
\usage{
getBulletinRegionGeomSPDF(RegionNames = "All", Agency = NA, Season,
  AsCentroid = F, CoreRegionsOnly = T, Verbose = F,
  SuppressDBWarnings = T)
}
\arguments{
\item{RegionNames}{Single or array of bulletin region names. Default is 'All'}

\item{Agency}{Instead of RegionsNames, it is possible to provide the Agency name. Either AvCan or PkCan.}

\item{Season}{Single or array of season for bulletin regions.}

\item{AsCentroid}{Switch for whether returned geometry should be the centroid. Default value is F.}

\item{CoreRegionsOnly}{Switch for whether core regions should be returned only. Default value is T.}

\item{Verbose}{Switch for printing of query}

\item{SuppressDBWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\value{
Appropriate sp spatial objects (SpatialPoints, SpatialLines, SpatialPolygons)
}
\description{
Gets bulletin region geometry as spatial dataframe
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

BulletinRegions <- c("Purcells", "Sea-to-Sky")
Season <- "2016"

BulletinRegionSPDF <- getBulletinRegionGeomSPDF(RegionNames=BulletinRegions, Season=Season)
plot(BulletinRegionSPDF)

BulletinRegionSPDF_AsCentroid <- getBulletinRegionGeomSPDF(RegionNames=BulletinRegions, Season=Season, AsCentroid = T)
plot(BulletinRegionSPDF_AsCentroid, pch=21, cex=5, bg="red", add=T)

BulletinRegionSPDF <- getBulletinRegionGeomSPDF(Agency="PkCan", Season=Season)
plot(BulletinRegionSPDF)
}
