% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletins.R
\name{getBulletins}
\alias{getBulletins}
\title{Gets bulletin information in a list of dataframes.}
\usage{
getBulletins(Agency, Seasons = NA, StartDate = NA,
  EndDate = StartDate, Regions = "All", FromRDataFile = F,
  BestDBSourceInt = BestDBSource, User = "",
  SeasonType = "Operation", GetOnlyFinalBulletins = TRUE,
  Verbose = F, SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{Seasons}{List of seasons to be included in query.}

\item{StartDate}{Either publishing date of requested bulletin id or start date for time period if EndDate is provided as well.}

\item{EndDate}{End date for time period of requested bulletin ids.}

\item{Regions}{Name of bulletin region}

\item{FromRDataFile}{Switch whether data should be retrieved from RData file posted on http://data.avalancheresearch.ca instead of the database. Default is False.}

\item{BestDBSourceInt}{Dataframe with information about best data source DB to be used for query. Default is the BestDBSource dataframe that is included in the package.}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{SeasonType}{Parameter passed on to deriveAvSeasonInfo() from SARPGeneral package to specify start and end date of a season. Values are 'Operation' (Dec. 15 to Apr. 15) (default) or 'AvYear' (Oct. 1 to Sept. 30).}

\item{GetOnlyFinalBulletins}{Switch for specifying whether to only include final bulletins in the dataframe. When a bulletin is published twice, only the last one is included. Default is TRUE.}

\item{Verbose}{Switch for printing SQL queries. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
Object of type Bulletins
}
\description{
Gets bulletin information in a list of dataframes.
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

## Get single bulletin from single region
Agency <- "AvCan"
Date <- "2015-02-05"
Region <- "Kootenay Boundary"
Bulletin <- getBulletins(Agency, StartDate=Date, Regions=Region)
summary(Bulletin)

## Get bulletins from single region for date range
Agency <- "AvCan"
StartDate <- "2015-02-05"
EndDate <- "2015-02-12"
Region <- "Kootenay Boundary"
Bulletin <- getBulletins(Agency, StartDate=StartDate, EndDate=EndDate, Regions=Region)
summary(Bulletin)

## Get bulletins from single region for entire season
Agency <- "AvCan"
Season <- 2015
Region <- "Kootenay Boundary"
Bulletin <- getBulletins(Agency, Seasons=Season, Regions=Region)
summary(Bulletin)

## Get bulletins from single region for multiple seasons
Agency <- "AvCan"
Seasons <- c(2013:2015)
Region <- "Kootenay Boundary"
Bulletin <- getBulletins(Agency, Seasons=Seasons, Regions=Region)
summary(Bulletin)

## Get bulletins from multiple regions for single date
Agency <- "AvCan"
Date <- "2015-02-05"
Regions <- c("South Coast - Inland", "Sea-to-Sky")
Bulletin <- getBulletins(Agency, StartDate=Date, Regions=Regions)
summary(Bulletin)

## Get bulletins from all regions for single date
Agency <- "AvCan"
Date <- "2015-02-05"
Bulletin <- getBulletins(Agency, StartDate=Date)
summary(Bulletin)

## Get Glacier bulletins from database
Agency <- "PkCan"
Season <- 2017
Region <- "Glacier"
Bulletin <- getBulletins(Agency, Seasons=Season, Regions=Region)
summary(Bulletin)

## Get Glacier bulletins from RData file instead
Bulletin <- getBulletins(Agency, Seasons=Season, Regions=Region, FromRDataFile = T)
summary(Bulletin)

}
