% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBulletinsAll.R
\name{getBulletinsAll}
\alias{getBulletinsAll}
\title{Get all bulletins.}
\usage{
getBulletinsAll(Agency = NA, SeasonType = "Operation")
}
\arguments{
\item{Agency}{Optional parameter for specifying agency: NA (default) includes all agencies, 'AvCan' or 'PkCan' includes only bulletins from Avalanche Canada or Parks Canada.}

\item{SeasonType}{Parameter passed on to deriveAvSeasonInfo() from SARPGeneral package to specify start and end date of a season. Values are 'Operation' (Dec. 15 to Apr. 15) (default) or 'AvYear' (Oct. 1 to Sept. 30).}
}
\value{
Object of type Bulletins
}
\description{
Wrapper function for getting all bulletins in a convenient way.
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

## Get bulletin
Bulletins <- getBulletinsAll()
summary(Bulletins)

## For Mac and Linux users who cannot access the DB directly, you can get all bulletins with
## load(url("http://data.avalancheresearch.ca/AllBulletins_2010To2017.RData"))

## Format for hazard analysis
AnalysisDF <- formatBulletinObjForHzdAnalysis(Bulletins)

}
