% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDailyWxObsFromWxDB.R
\name{getDailyWxObsFromWxDB}
\alias{getDailyWxObsFromWxDB}
\title{Gets computed daily weather observations from WeatherDB}
\usage{
getDailyWxObsFromWxDB(Source, OperName, WxSiteName, DateStart = NA,
  DateEnd = DateStart)
}
\arguments{
\item{Source}{The source of the weather data. Must be 'InfoEx', BCMoTI' or 'EnvCan'}

\item{OperName}{Name of operation}

\item{WxSiteName}{Name of weather site}

\item{DateStart}{Start date of time period. Default value is NA.}

\item{DateEnd}{End date of time period. Default value is same as DateStart.}
}
\value{
Dataframe with result
}
\description{
Gets computed daily weather observations from WeatherDB
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

WxObs_All  <- getDailyWxObsFromWxDB("InfoEx", "Whitewater Ski Resort", "Summit Study Plot")
WxObs_2016 <- getDailyWxObsFromWxDB("InfoEx", "Whitewater Ski Resort", "Summit Study Plot", DateStart = "2015-10-01", DateEnd = "2016-05-01")

}
