% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDailyWxObsFromWxDBOverview.R
\name{getDailyWxObsFromWxDBOverview}
\alias{getDailyWxObsFromWxDBOverview}
\title{Gets overview of daily weather observations available from WeatherDB.}
\usage{
getDailyWxObsFromWxDBOverview(DateStart = NA, DateEnd = DateStart)
}
\arguments{
\item{DateStart}{Start date of time period. Default value is NA.}

\item{DateEnd}{End date of time period. Default value is same as DateStart.}
}
\value{
List with summary tables with data frames from each source
}
\description{
Gets overview of daily weather observations available from WeatherDB.
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

Overview_All  <- getDailyWxObsFromWxDBOverview()
Overview_2016 <- getDailyWxObsFromWxDBOverview(DateStart = "2015-10-01", DateEnd = "2016-05-01")

}
