% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getListForecastRegions.R
\name{getListForecastRegions}
\alias{getListForecastRegions}
\title{Gets dataframe with list of available forecast regions}
\usage{
getListForecastRegions(Agency, DBFormat = "AvalX", User = "",
  Verbose = F, SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{DBFormat}{Name of database type. Needs to be either 'AvalX' (default), 'Bulletin' or 'HzdWebsite'}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
Dataframe with result
}
\description{
Gets dataframe with list of available forecast regions
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

getListForecastRegions("PkCan")
getListForecastRegions("AvCan")
getListForecastRegions("AvCan", "Bulletin")
getListForecastRegions("AvCan", "HzdWebsite")

}
