% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNumBulletinsForSeason.R
\name{getNumBulletinsForSeason}
\alias{getNumBulletinsForSeason}
\title{Gets list of dataframes what lists number of bulletins in different database formats for agency}
\usage{
getNumBulletinsForSeason(Agency, Season, User = "", Verbose = F,
  SuppressDBWarnings = T)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{Season}{Single season number (e.g., '2015' for 2014/15 winter season)}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
List with results
}
\description{
Gets list of dataframes what lists number of bulletins in different database formats for agency
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

getNumBulletinsForSeason("PkCan", 2015)
getNumBulletinsForSeason("AvCan", 2015)

}
