% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProvincesGeomSPDF.R
\name{getProvincesGeomSPDF}
\alias{getProvincesGeomSPDF}
\title{Gets provinces geometry as spatial dataframe}
\usage{
getProvincesGeomSPDF(AsCentroid = F, Verbose = F,
  SuppressDBWarnings = T)
}
\arguments{
\item{AsCentroid}{Switch for whether returned geometry should be the centroid. Default value is F.}

\item{Verbose}{Switch for printing of query}

\item{SuppressDBWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Turn on for debugging!}
}
\value{
Appropriate sp spatial objects (SpatialPoints, SpatialLines, SpatialPolygons)
}
\description{
Gets provinces geometry as spatial dataframe
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

ProvincesSPDF <- getProvincesGeomSPDF()
plot(ProvincesSPDF)

}
