% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecordsFromQuery.R
\name{getRecordsFromQuery}
\alias{getRecordsFromQuery}
\title{Gets record from bulletin database based on SQL query}
\usage{
getRecordsFromQuery(Agency, Query, DBFormat = "AvalX", User = "",
  ReadOnly = T, Verbose = F, SuppressDBWarnings = T,
  MaxNumTries = 10)
}
\arguments{
\item{Agency}{Name of agency (PkCan or AvCan)}

\item{Query}{Properly formatted SQL query}

\item{DBFormat}{Name of database type. Needs to be either 'AvalX' (default), 'Bulletin' or 'HzdWebsite'}

\item{User}{Name of user accessing the database. This name is used to record database interactions and to potentially access local resources (i.e., local folder JDBC driver)}

\item{ReadOnly}{Switch for specifiying whether query is sent with read only or read and write credentials.}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressDBWarnings}{Switch for turning warnings off. Default value is TRUE.}
}
\value{
Dataframe with result
}
\description{
Gets record from bulletin database based on SQL query
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

RegionNamesPkCan_AvalX <- getRecordsFromQuery("PkCan", "SELECT DESC_EN AS REGION_NAME FROM ABS_REGION")
RegionNamesAvCan_AvalX <- getRecordsFromQuery("AvCan", "SELECT DESC_EN AS REGION_NAME FROM ABS_REGION")
RegionNamesAvCan_HzdWebsite <- getRecordsFromQuery("AvCan", "SELECT tbl_regions.`Name` AS REGION_NAME FROM tbl_regions", DBFormat="HzdWebsite")

}
