% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importBulletinRegionGeom.R
\name{importBulletinRegionGeom}
\alias{importBulletinRegionGeom}
\title{Write geometries of bulletin region to bulletin geodatabase.}
\usage{
importBulletinRegionGeom(Folder, ShpFileName, SeasonStart = NA,
  SeasonEnd = NA, Agency = NA)
}
\arguments{
\item{Folder}{Complete path of folder that contains shape files}

\item{ShpFileName}{Name of shape file without file extension (i.e., shp)}

\item{SeasonStart}{Season when the geometries to be imported where first used.}

\item{SeasonEnd}{Season when the geometries to be imported where last used.}

\item{Agency}{Name of agency whose bulletin regions are imported.}
}
\description{
Write geometries of bulletin region to bulletin geodatabase.
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

Folder <- "C:\\\\Temp\\\\bulletinregions\\\\shp"
ShpFileName <- "16_BulletinRegions_CAC"

importBulletinRegionGeom(Folder, ShpFileName, SeasonStart=2017, SeasonEnd=2018)

}
